const mongoose = require("mongoose");

const orderSchema = new mongoose.Schema(
  {
    user: {
      _id: { type: mongoose.Schema.ObjectId, ref: "User", required: true },
      name: String,
      email: String,
    },
    // Array of courses (Since cart has multiple items)
    items: [
      {
        course: { type: mongoose.Schema.ObjectId, ref: "Course" },
        name: String,
        price: Number,
        coverImage: String,
      },
    ],
    totalPrice: { type: Number, required: true },

    // 🔥 New Paymob Fields
    paymobOrderId: { type: String }, // Paymob's ID for the order
    paymentStatus: {
      type: String,
      enum: ["pending", "paid", "failed"],
      default: "pending",
    },

    status: {
      type: String,
      enum: ["pending", "completed", "cancelled"],
      default: "pending",
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Order", orderSchema);
